using System;
using System.Collections;
using Enumerators;
using Utilities;
namespace Processes
{
    /// <summary>
    /// Obiekty tej klasy reprezentuj pojedyncze etapy procesw lub 
    /// zoenia etapw procesw. Proces to w uproszczeniu przepis przygotowania
    /// okrelonego produktu - w tym przypadku fajerwerkw.
    /// </summary>
    public abstract class ProcessComponent : ICompositeEnumerable
    {
        protected String _name;
        /// <summary>
        /// Tworzy komponent procesu o zadanej nazwie.
        /// </summary>
        /// <param name="name">nazwa komponentu procesu</param>
        public ProcessComponent(String name)
        {
            _name = name;
        }
        /// <summary>
        /// Przyjmuje gocia.
        /// </summary>
        /// <param name="v">go</param>
        public abstract void Accept(IProcessVisitor v);
        /// <summary>
        /// Zwraca nazw komponentu.
        /// </summary>
        public String Name
        {
            get 
            {
                return _name;
            }
        }
        /// <summary>
        /// Zwraca enumerator do bezpiecznego przechodzenia tego kompozytu.
        /// </summary>
        /// <returns>enumerator do bezpiecznego przechodzenia tego kompozytu</returns>
        public IEnumerator GetEnumerator()
        {
            return GetEnumerator(new Set());
        }
        /// <summary>
        /// Zwraca odpowiedniego typu iterator komponentw.
        /// </summary>
        /// <param name="visited">Zbir poprzednio odwiedzonych wzw</param>
        /// <returns>odpowiedniego typu iterator komponentw</returns>
        public abstract ComponentEnumerator GetEnumerator(Set visited);

        /// <summary>
        /// Zwraca liczb etapw bdcych limi biecego kompozytu.
        /// </summary>
        /// <returns>liczb etapw bdcych limi biecego kompozytu</returns>
        public int GetStepCount()
        {
            return GetStepCount(new Hashtable());
        }
        /// <summary>
        /// Zwraca liczb etapw bdcych limi biecego kompozytu.
        /// </summary>
        /// <param name="visited">zbir komponentw ju odwiedzonych w ramach 
        /// przechodzenia biecego wza</param>
        /// <returns>liczb etapw bdcych limi biecego kompozytu</returns>
        public abstract int GetStepCount(Hashtable visited);
        /// <summary>
        /// Zwraca tekstow reprezentacj biecego komponentu.
        /// </summary>
        /// <returns>tekstow reprezentacj biecego komponentu</returns>
        public override String ToString()
        {
            return _name;
        }
    }
}
