using System;
using System.Collections;

namespace Processes
{
    /// <summary>
    /// Reprezentuje alternacj (moliwo wyboru) etapw procesw.
    /// </summary>
    public class ProcessAlternation : ProcessComposite 
    {
        /// <summary>
        /// Tworzy alternacj o zadanej nazwie.
        /// </summary>
        /// <param name="name">nazwa alternacji procesu</param>
        public ProcessAlternation(String name) : base(name)
        {
        }
        /// <summary>
        /// Tworzy alternacj o zadanej nazwie, zawierajc zadane podprocesy.
        /// </summary>
        /// <param name="name">nazwa alternacji</param>
        /// <param name="subprocesses">podprocesy alternacji</param>
        public ProcessAlternation(
            String name,
            params ProcessComponent[] subprocesses) : base (name, subprocesses)
        {
        }
        /// <summary>
        /// Tworzy alternacj o zadanej nazwie, zawierajc zadane podprocesy.
        /// </summary>
        /// <param name="name">nazwa alternacji</param>
        /// <param name="subprocesses">podprocesy alternacji</param>
        public ProcessAlternation(String name, IList subprocesses) : 
            base(name, subprocesses)
        {
        }
        /// <summary>
        /// Zaczep pozwalajcy gociom dodawa operacje do kompozytu procesw.
        /// Chodzi o to, by odwoa si z powrotem do gocia wskazujc 
        /// jednoczenie typ wza, czyli ProcessAlternation.
        /// </summary>
        /// <param name="v"></param>
        public override void Accept(IProcessVisitor v)
        {
            v.Visit(this);
        }
    }
}
