using System;

namespace Machines
{ 
    /// <summary>
    /// Modeluje standardowy, gumowy pojemnik, mieszczcy okoo czterech litrw
    /// zwizku chemicznego. Klasa stanowi minimalny model, pokazujcy sposb
    /// zarzdzania relacj jeden do wielu w modelu obiektowym.
    /// </summary>
    public class Tub 
    {
        private String _id;
        private TubMediator _mediator = TubMediator.SINGLETON;
        /// <summary>
        /// Tworzy pojemnik o podanym identyfikatorze, zarzdzany przez 
        /// mediatora.
        /// </summary>
        /// <param name="id">identyfikator pojemnika</param>
        public Tub(String id)
        {
            _id = id;
        }
        /// <summary>
        /// Pobieranie i ustawianie lokalizacji pojemnika za porednictwem mediatora.
        /// Pozwala to zapobiec zamodelowaniu lokalizacji pojemnika przy dwch
        /// maszynach jednoczenie.
        /// </summary>
        public Machine Location
        {
            get
            {
                return _mediator.GetMachine(this);
            }
            set
            {
                _mediator.Set(this, value);
            }
        }
        /// <summary>
        /// Zwraca tekstow reprezentacj pojemnika.
        /// </summary>
        /// <returns>tekstow reprezentacj pojemnika</returns>
        public override String ToString()
        {
            return _id;
        }
        /// <summary>
        /// Zwraca unikalny identyfikator pojemnika.
        /// </summary>
        /// <returns>unikalny identyfikator pojemnika</returns>
        public override int GetHashCode()
        {
            return _id.GetHashCode();
        }
        /// <summary>
        /// Zwraca true jeli z biznesowego punktu widzenia biecy obiekt
        /// i dostarczony obiekt odwouj si do tej samej maszyny.
        /// </summary>
        /// <param name="o">porwnywany obiekt</param>
        /// <returns>true jeli biecy obiekt i dostarczony obiekt 
        /// odwouj si do tej samej maszyny</returns>
        public override bool Equals(Object o)
        {
            if (o == this)
            {
                return true;
            }
            if (!(o is Tub))
            {
                return false;
            }                                                    
            Tub t = (Tub) o;
            return _id.Equals(t._id);
        }
    }
}
