using System;
namespace Machines
{
    /// <summary>
    /// Modeluje wzek narzdziowy.
    /// </summary>
    public class ToolCart : VisualizationItem
    {
        protected Engineer _responsible;

        /// <summary>
        /// Konstrukcja wzka narzdziowego wraz z zapisaniem inyniera
        /// odpowiedzialnego za narzdzia na tym wzku.
        /// </summary>
        /// <param name="e">inynier odpowiedzialny</param>
        public ToolCart(Engineer e)
        {
            this._responsible = e;
        }
        /// <summary>
        /// Inynier odpowiedzialny za narzdzia na tym wzku.
        /// </summary>
        public Engineer Responsible
        {
            get 
            {
                return _responsible;
            }
            set 
            {
                this._responsible = value;
            }
        }
    }
}
