using System;
namespace Machines
{
    /// <summary>
    /// Model prasy gwiazdowej, toczcej z pasty chemicznej wybuchajce kulki,
    /// czyli gwiazdy.
    /// </summary>
    public class StarPress : Machine
    {
        // private StarPressPlanner _planner; // usunite w ramach przeksztacenia w rozdziale Template Method
        /// <summary>
        /// Tworzy maszyn o podanym identyfikatorze i maszynie macierzystej.
        /// </summary>
        /// <param name="id">identyfikator maszyny</param>
        public StarPress(int id) : base (id)
        {
        }
        /// <summary>
        /// Zwraca obiekt planujcy dla biecej maszyny.
        /// </summary>
        /// <returns>obiekt planujcy dla biecej maszyny</returns>
        public override MachinePlanner CreatePlanner() 
        {
            return new StarPressPlanner(this);
        }

        /* (poniszy kod jest usunity w ramach przeksztacenia w rozdziale Template Method)
        public StarPressPlanner GetPlanner() 
        { 
            if (_planner == null) 
            {
                _planner = new StarPressPlanner(this);
            }
            return _planner;
        }
        */ 
    }
}
