using System;
namespace Machines
{
    /// <summary>
    /// Model maszyny montujcej petardy powietrzne z gwiazd, prochu 
    /// i tekturowej obudowy.
    /// </summary>
    public class ShellAssembler : Machine
    {
        // private ShellPlanner _planner; // usunite w ramach przeksztacenia w rozdziale Template Method
        /// <summary>
        /// Tworzy maszyn o podanym identyfikatorze i maszynie macierzystej.
        /// </summary>
        /// <param name="id">identyfikator maszyny</param>
        public ShellAssembler(int id) : base (id)
        {
        }
        /// <summary>
        /// Zwraca obiekt planujcy dla biecej maszyny.
        /// </summary>
        /// <returns>obiekt planujcy dla biecej maszyny</returns>
        public override MachinePlanner CreatePlanner() 
        {
            return new ShellPlanner(this);
        }

        /* (poniszy kod jest usunity w ramach przeksztacenia w rozdziale Template Method)
        public ShellPlanner GetPlanner() 
        {
            if (_planner == null) 
            {
                _planner = new ShellPlanner(this);
            }
            return _planner;
        }
        */
    }
}
