using System;
namespace Functions
{
    /// <summary>
    /// Opakowuje funkcj Math.Sqrt() wok podanego rda.
    /// </summary>
    public class Sqrt : Frapper 
    {
        /// <summary>
        /// Konstrukcja funkcji pierwiastka kwadratowego doczanej do 
        /// dostarczonej funkcji rdowej.
        /// </summary>
        /// <param name="f">Inna klasa opakowujca funkcj</param>
        public Sqrt(Frapper f) : base (f)
        {
        }
        /// <summary>
        /// Zwraca wynik wykonania Math.Sqrt() na wartoci funkcji rdowej
        /// w momencie t.
        /// </summary>
        /// <param name="t">time</param>
        /// <returns>pierwiastek kwadratowy wartoci funkcji rdowej 
        /// w momencie t</returns>
        public override double F(double t)
        {
            return Math.Sqrt(_sources[0].F(t));
        }
    }
}
