using System;
namespace Functions
{
    /// <summary>
    /// Opakowuje funkcj Math.Abs() wok wartoci rdowej.
    /// </summary>
    public class Abs : Frapper 
    {
        /// <summary>
        /// Konstrukcja funkcji wartoci bezwzgldnej, doczanej do
        /// dostarczonej funkcji rdowej.
        /// </summary>
        /// <param name="f">Inna klasa opakowujca funkcj</param>
        public Abs(Frapper f) : base (f)
        {
        }
        /// <summary>
        /// Zwraca wynik zastosowania Math.Abs() do wartoci funkcji rdowej
        /// w momencie t.
        /// </summary>
        /// <param name="t">time</param>
        /// <returns>warto bezwzgldn wartoci funkcji rdowej w momencie t</returns>
        public override double F(double t)
        {
            return Math.Abs(_sources[0].F(t));
        }
    }
}
