using System;

namespace Fireworks
{
    /// <summary>
    /// Fajerwerk z wasnym napdem.
    /// </summary>
    public class Rocket : Firework
    {
        private double _apogee;
        private double _thrust;

        /// Umoliwia tworzenie pustych obiektw w celu obsuenia rekonstrukcji
        /// z pamici trwaej.
        public Rocket()
        {
        }
        /// <summary>
        /// Utworzenie rakiety o podanych wasnociach.
        /// </summary>
        /// <param name="apogee">Maksymalna wysoko (w metrach), jak
        /// rakieta ma osiga</param>
        /// <param name="thrust">Nominalny cig (sia w niutonach) dla tej
        /// rakiety</param>
        /// Opis pozostaych parametrw w definicji nadklasy
        public Rocket(string name, double mass, decimal price, double apogee, double thrust) : 
            base (name, mass, price)
        {
            Apogee = apogee;
            Thrust = thrust;
        }
        /// <summary>
        /// Maksymalna wysoko (w metrach), jak rakieta ma osiga.
        /// </summary>
        public double Apogee 
        {
            get
            {
                return _apogee;
            }
            set  
            {
                _apogee = value;
            }
        }
        /// <summary>
        /// Nominalny cig (sia w niutonach) dla tej rakiety.
        /// </summary>
        public double Thrust 
        {
            get
            {
                return _thrust;
            }
            set  
            {
                _thrust = value;
            }
        }
    }
}
