using System;
using System.Collections;
using Utilities;
namespace Enumerators
{
    /// <summary>
    /// Abstrakcyjna nadklasa dla enumeratorw, definiujca metody do 
    /// przechodzenia po liciach i kompozytach w ramach drzewa kompozytw.
    /// </summary>
    public abstract class ComponentEnumerator : IEnumerator
    {
        protected Object _head;
        protected Set _visited;
        protected Object _current;
        protected bool _returnInterior = true;

        /// <summary>
        /// Zwraca biecy wze.
        /// </summary>
        public Object Current 
        {
            get
            {
                return _current;
            }
        }

        /// <summary>
        /// Okrela, czy wewntrzne wzy powinny wystpowa iteracyjnie.
        /// </summary>
        public bool ReturnInterior
        {
            get
            {
                return _returnInterior;
            }
            set 
            {
                _returnInterior = value;
            }
        }
        /// <summary>
        /// Tworzy enumerator nad wzem w ramach kompozytu.
        /// </summary>
        /// <param name="node">wze do przechodzenia</param>
        /// <param name="visited">zbir do zapisywania odwiedzonych wzw</param>
        public ComponentEnumerator(Object head, Set visited)
        {
            _head = head;
            _visited = visited;
        }

        /// <summary>
        /// Zwraca biec gboko iteracji.
        /// </summary>
        /// <returns>biec gboko iteracji (tzn. ilo wzw nad biecym)</returns>
        public abstract int Depth();

        /// <summary>
        /// Przesunicie enumeratora.
        /// </summary>
        /// <returns>true jeli dostpny jest kolejny wze</returns>
        public abstract bool MoveNext();

        /// <summary>
        /// Operacja nieobsugiwana.
        /// </summary>
        public void Reset() 
        { 
            throw new InvalidOperationException("Funkcja Reset() nie jest jeszcze obsugiwana!"); 
        }
    }
}
