using System;
namespace Credit
{
    /// <summary>
    /// Fabryka obiektw do sprawdzania zdolnoci kredytowej.
    /// </summary>
    public abstract class CreditCheckFactory 
    {
        /// <summary>
        /// Zwraca obiekt implementujcy ICreditCheck. Jego faktyczna klasa
        /// zaley od aktualnej dostpnoci agencji kredytowej.
        /// </summary>
        /// <returns>obiekt implementujcy ICreditCheck</returns>
        public static ICreditCheck CreateCreditCheck()
        {
            if (IsAgencyUp())
            {
                return new CreditCheckOnline();
            }
            else
            {
                return new CreditCheckOffline();
            }
        }
        /// <summary>
        /// Zwraca true jeli agencja kredytowa jest dostpna. Metoda na 
        /// razie nie jest zaimplementowana.
        /// </summary>
        /// <returns>true jeli agencja kredytowa jest dostpna</returns>
        public static bool IsAgencyUp()
        {
            return true;
        }
        /// <summary>
        /// Zwraca obiekt implementujcy IBillingCheck. Jego faktyczna
        /// klasa zaley od konkretnej podklasy.
        /// </summary>
        /// <returns>obiekt implementujcy IBillingCheck</returns>
        public abstract IBillingCheck CreateBillingCheck();
        /// <summary>
        /// Zwraca obiekt implementujcy ICreditCheck. Jego faktyczna
        /// klasa zaley od konkretnej podklasy.        
        /// </summary>
        /// <returns>obiekt implementujcy ICreditCheck</returns>
        public abstract ICreditCheck CreateCreditCheck2();
        /// <summary>
        /// Zwraca obiekt implementujcy IShippingCheck. Jego faktyczna
        /// klasa zaley od konkretnej podklasy.
        /// </summary>
        /// <returns>obiekt implementujcy IShippingCheck</returns>
        public abstract IShippingCheck CreateShippingCheck();
    }
}
