using System;

namespace Controllers
{
	/// <summary>
    /// Meneder maszyny adaptujcy wsplny interfejs klasy MachineManager
    /// do konkretnego protokou komunikacyjnego kontrolera prasy gwiazdowej.
	/// </summary>
	public class StarPressManager : MachineManager
	{
        private StarPressController _controller = new StarPressController();
        public override void StartMachine() 
        {
            _controller.Start();
        }
        public override void StopMachine() 
        {
            _controller.Stop();
        }
        public override void StartProcess() 
        {
            _controller.StartProcess();
        }
        public override void StopProcess() 
        {
            _controller.EndProcess();
        }
        public override void ConveyIn() 
        {
            _controller.Index();
        }
        public override void ConveyOut() 
        {
            _controller.Discharge();
        }
	}
}
