using System;
using System.Collections;
namespace BusinessCore
{  
    /// <summary>
    /// Klasa wykorzystywana w wielu przykadach bazujcych na zaoeniu,
    /// e istnieje jeden centralny obiekt reprezentujcy fabryk Oozinoz.
    /// </summary>
    public class Factory 
    {
        private static Factory _factory; 
        private static Object _classLock = typeof(Factory);
        private long _wipMoves;
        private Factory()
        {
            _wipMoves = 0;
        }
        public static Factory GetFactory()
        {
            lock (_classLock)
            {
                if (_factory == null)
                {
                    _factory = new Factory();
                }
                return _factory;
            }
        }
        public void RecordWipMove()
        {
            lock (_classLock)
            {
                _wipMoves++;
            }
        }
        // do przykadu z pras gwiazdow Aster, nieimplementowana
        public void CollectPaste() 
        {
        }

        /// <summary>
        /// Zwraca przykadow list aktywnych maszyn, pobieran przez
        /// aplikacj ShowConcurrentWhile i inne przykady.
        /// </summary>
        /// <returns>przykadow list aktywnych maszyn</returns>
        public static ArrayList UpMachineNames()
        {
            return new ArrayList(
                new String[] {
                                 "Mixer:1201",
                                 "ShellAssembler:1301",
                                 "StarPress:1401",
                                 "UnloadBuffer:1501" } );
        }
    }
}
