using System;
using System.Drawing;
using System.Windows.Forms;
using UserInterface;
/// <summary>
/// Klasa demonstrujca zastosowanie wzorca Proxy. Co istotne, tekst rozdziau
/// Proxy przedstawia argumenty przeciwko stosowaniu takiego podejcia.
/// </summary>
public class PictureBoxProxy : Control
{
    private PictureBox _pictureBox;
    private string _imageName;
    private Image _image; 
    /// <summary>
    /// Tworzy porednika dla obiektu PictureBox, adowanego w oczekiwaniu na
    /// zaadowanie tego ostatniego.
    /// </summary>
    /// <param name="pictureBox">obiekt PictureBox zastpowany przez porednika</param>
    /// <param name="imageName">nazwa obrazu</param>
    /// 
    public PictureBoxProxy(PictureBox pictureBox, string imageName)
    {
        _pictureBox = pictureBox;
        _imageName = imageName;
    }
    /// <summary>
    /// Zwraca obraz podstawowy.
    /// </summary>
    public Image Image 
    {
        get 
        {
            if (_image == null) 
                return _pictureBox.Image; 
            else 
                return _image;
        }
    }
    /// <summary>
    /// Poniesienie kosztu zaadowania obrazu docelowego.
    /// </summary>
    public void Load() 
    {
        _image = UI.GetImage(_imageName);
    }
    protected override void OnPaint(PaintEventArgs pea) 
    {
        Graphics g = pea.Graphics;
        g.DrawImage(Image, 0, 0);
    }
}