using System;
using System.Collections;
using System.Threading;
using BusinessCore;
/// <summary>
/// Pokazuje e iterowanie po synchronizowanej licie moe wskaza
/// problem z obsug wielowtkowoci.
/// </summary>
public class ShowConcurrentWhile   
{
    private ArrayList _list;
    protected void DisplayUpMachines()
    {
        _list = ArrayList.Synchronized(Factory.UpMachineNames());
        IEnumerator i = _list.GetEnumerator();
        int counter = 0;
        while (i.MoveNext())
        {
            if (++counter == 2)
            { // symulacja obudzenia wtku
                new Thread(new ThreadStart(NewMachineComesUp)).Start();
            }
            Thread.Sleep(100); // dopuszczenie innych wtkw
            Console.WriteLine(i.Current);
        }
    }
    /// <summary>
    /// Symulacja dodania nowej maszyny do listy, po ktrej wanie iterujemy.
    /// </summary>
    public void NewMachineComesUp()
    {
        _list.Insert(0, "Fuser:1101");
    }
    /// <summary>
    /// Punkt wejcia aplikacji.
    /// </summary>
    public static void Main()
    {
        Console.WriteLine(
            @"Dziaanie programu koczy si awari w celu zademonstrowania efektw modyfikacji 'synchronizowanej' listy podczas iterowania po niej.");
        new ShowConcurrentWhile().DisplayUpMachines();
    }
}