using System;
using System.Drawing;
using System.IO;
using System.Reflection;
namespace Utilities
{
    /// <summary>
    /// Klasa dostarczajca metody statyczne do lokalizacji plikw wzgldem
    /// podkatalogu bin, w ktrym uruchamiana jest ta jednostka kompilacji.
    /// </summary>
    public class FileFinder
    {
        /// <summary>
        /// Tworzy i zwraca nazw dla pliku w ssiednim katalogu. Zmienna
        /// rodowiskowa OOZINOZ zawiera ciek katalogu nadrzdnego dla
        /// podkatalogw lib, app, images i pozostaych. Jeli brak tej zmiennej,
        /// metoda wylicza katalog na podstawie lokalizacji biecej jednostki
        /// kompilacji. To na og skutkuje, ale nie zadziaa w przypadku 
        /// aplikacji kopiujcych pliki DLL do rnych katalogw, co czyni
        /// niektre rodowiska testujce.
        /// </summary>
        /// <param name="dirName">nazwa ssiedniego katalogu</param>
        /// <param name="fileName">nazwa pliku</param>
        /// <returns>ciek ssiedniego pliku</returns>
        public static String GetFileName(String dirName, String fileName)
        {
            String path;
            // Czy da si odnale plik korzystajc ze zmiennej rodowiskowej OOZINOZ?
            String oozinozBase = Environment.GetEnvironmentVariable("OOZINOZ");
            if (oozinozBase != null) 
            {
                path = Path.Combine(Path.Combine(oozinozBase, dirName), fileName);
                if (File.Exists(path))
                {
                    return path;
                }
            }
            // A moe wzgldem podkatalogu bin?
            Assembly a = Assembly.GetAssembly(typeof(FileFinder));
            DirectoryInfo thisDir = Directory.GetParent(a.Location);
            DirectoryInfo parentDir = Directory.GetParent(thisDir.FullName);
            path = Path.Combine(
                parentDir.FullName, 
                dirName + Path.DirectorySeparatorChar + fileName);
            if (File.Exists(path))
            {
                return path;
            }
            // No dobra, to moe pod katalogiem gwnym?
            path = Path.Combine(Path.Combine(@"\oozinoz", dirName), fileName);
            if (File.Exists(path))
            {
                return path;
            }
            // Guzik
            throw new Exception("FileFinder.GetFileName() nie moe znale " + fileName + " w katalogu " + dirName);

        }
    }
}
