using System;
using Machines;

namespace RobotInterpreter2
{
    /// <summary>
    /// Klasa reprezentuje polecenie wczajce urzdzenie wskazywane
    /// przez dostarczony termin.
    /// </summary>
    public class StartUpCommand : Command 
    {
        protected Term _term;

        /// <summary>
        /// Konstrukcja polecenia wczajcego urzdzenie wskazywane
        /// przez dostarczony termin.
        /// </summary>
        /// <param name="term">termin sprawdzany w wyniku wykonania polecenia;
        /// wskazywana przez przez niego maszyna zostanie wczona</param>
        public StartUpCommand(Term term)
        {
            _term = term;
        }

        /// <summary>
        /// Okrela maszyn wskazywan przez termin i wcza j.
        /// </summary>
        public override void Execute()
        {
            Machine m = _term.Eval();
            m.StartUp();
        }
    }
}
