using System;
using Machines;

namespace RobotInterpreter2
{
    /// <summary>
    /// Odpowiada konkretnej maszynie.
    /// </summary>
    public class Constant : Term 
    {
        protected Machine _machine;

        /// <summary>
        /// Konstrukcja terminu zawsze odwoujcego si do konkretnej maszyny.
        /// </summary>
        /// <param name="machine"></param>
        public Constant(Machine machine)
        {
            _machine = machine;
        }

        /// <summary>
        /// Zwraca true, jeli dostarczony obiekt jest rwny biecemu.
        /// </summary>
        /// <param name="o">porwnywany obiekt</param>
        /// <returns>true, jeli dostarczony obiekt jest rwny biecemu</returns>
        public override bool Equals(Object o)
        {
            if (o == this)
            {
                return true;
            }
            Constant c = o as Constant;
            if (c == null) 
            {
                return false; 
            }
            return _machine.Equals(c._machine);
        }

        /// <summary>
        /// Zwraca klucz do obiektu.
        /// </summary>
        /// <returns>klucz dla obiektu</returns>
        public override int GetHashCode()
        {
            return _machine.GetHashCode();
        }

        /// <summary>
        /// Zwraca maszyn, ktrej odpowiada biecy obiekt.
        /// </summary>
        /// <returns>maszyn, ktrej odpowiada biecy obiekt</returns>
        public override Machine Eval()
        {
            return _machine;
        }
        /// <summary>
        /// Zwraca tekstowy opis staej.
        /// </summary>
        /// <returns>tekstowy opis staej</returns>
        public override String ToString()
        {
            return _machine.ToString();
        }
    }
}
