using System;
using Machines;
namespace RobotInterpreter
{
    /// <summary>
    /// Klasa modelujca robota poruszajcego si po szynach, zbierajcego
    /// i odstawiajcego pojemniki materiaw dla maszyn.
    /// </summary>
    public class Robot 
    {
        public static readonly Robot singleton = new Robot();
        private Robot()
        {
        }

        /// <summary>
        /// Przesunicie do maszyny, podniesienie pojemnika, przesunicie
        /// do innej maszyny i postawienie pojemnika.
        /// </summary>
        /// <param name="m1">maszyna pocztkowa</param>
        /// <param name="m2">maszyna docelowa</param>
        public void Carry(Machine m1, Machine m2)
        {
            Console.WriteLine("Robot przenosi z " + m1 + " do " + m2);
            Bin b = m1.Unload();
            if (b != null) 
            {
                m2.Load(b);
            }
        }
    }
}
