using System;
using Machines;
namespace RobotInterpreter
{
    /// <summary>
    /// Obsuga przeniesienia pojemnika z jednej maszyny do drugiej,
    /// z moliwoci odwoywania si do maszyn wedug nazw.
    /// </summary>
    public class CarryCommand : Command 
    {
        protected Machine _fromMachine;
        protected Machine _toMachine;

        /// <summary>
        /// Konstrukcja polecenia przeniesienia pojemnika z jednej
        /// maszyny do drugiej.
        /// </summary>
        /// <param name="fromMachine">maszyna, przy ktrej obecnie stoi pojemnik</param>
        /// <param name="toMachine">maszyna docelowa dla pojemnika</param>
        public CarryCommand(Machine fromMachine, Machine toMachine)
        {
            _fromMachine = fromMachine;
            _toMachine = toMachine;
        }

        /// <summary>
        /// Przeksztaca odwoania na konkretne maszyny i przenosi
        /// pojemnik midzy odpowiednimi maszynami.
        /// </summary>
        public override void Execute()
        {
            Robot.singleton.Carry(_fromMachine, _toMachine);
        }
    }
}
