using System;

namespace Reservations
{
    /// <summary>
    /// Klasy dziedziczce z tej klasy abstrakcyjnej sprawdzaj poprawno
    /// atrybutw rezerwacji przed utworzeniem obiektu Reservation.
    /// </summary>
    public abstract class ReservationBuilder      
    {
        public static readonly int MINHEAD = 25;
        public static readonly decimal MINTOTAL = 495.95M;

        protected DateTime _date = DateTime.MinValue;
        protected String _city;
        protected int _headcount;
        protected decimal _dollarsPerHead;
        protected bool _hasSite;

        /// <summary>
        /// Przesunicie daty w przeszo poprzez zwikszenie roku.
        /// </summary>
        /// <param name="inDate">data do przesunicia</param>
        /// <returns>tak sam dat, jak dostarczona, ale z rokiem zmienionym
        /// tak, by bya ona w przyszoci</returns>
        public static DateTime Futurize(DateTime inDate)
        {
            DateTime outDate = inDate;
            while (outDate.CompareTo(DateTime.Now) < 0)
            {
                outDate = outDate.AddYears(1);
            }
            return outDate;
        }
        /// <summary>
        /// Konstrukcja poprawnej rezerwacji na podstawie dostarczonych
        /// atrybutw. Klasy potomne mog zgosi wyjtek, jeli nie da si
        /// utworzy poprawnej rezerwacji.
        /// </summary>
        /// <returns>poprawn rezerwacj</returns>
        public abstract Reservation Build();

        /// <summary>
        /// Miasto rezerwacji.
        /// </summary>
        public String City
        {
            get { return _city; }
            set { _city = value;}
        }
        /// <summary>
        /// Data rezerwacji.
        /// </summary>
        public DateTime Date
        {
            get { return _date; }
            set { _date = value;}
        }
        /// <summary>
        /// Cena od osoby, jak klient zapaci za pokaz.
        /// </summary>
        public decimal DollarsPerHead
        {
            get { return _dollarsPerHead; }
            set { _dollarsPerHead = value;}
        }
        /// <summary>
        /// Okrela, czy klient wybra ju konkretn lokalizacj dla pokazu.
        /// </summary>
        public bool HasSite
        {
            get { return _hasSite; }
            set { _hasSite = value;}
        }
        /// <summary>
        /// Ilo widzw gwarantowana przez klienta.
        /// </summary>
        public int Headcount
        {
            get { return _headcount; }
            set { _headcount = value;}
        }
    }
}
