using System;
using Aster;
using BusinessCore;

public class OzAsterStarPress : AsterStarPress
{
    /// <summary>
    /// Przesania nadklas, by robot mg zebra past wyrzucon przez
    /// maszyn przed zlaniem maszyny wod.
    /// </summary>
    public override void DischargePaste()
    {
        base.DischargePaste();
        GetFactory().CollectPaste();
    }

    /// <summary>
    /// Pobiera singleton menedera materiau.
    /// </summary>
    /// <returns>singleton menedera materiau</returns>
    public MaterialManager GetManager()
    {
        return MaterialManager.GetManager();
    }

    /// <summary>
    /// Powiadomienie menedera materiau Oozinoz, e dana forma zostaa
    /// niekompletnie przetworzona.
    /// </summary>
    /// <param name="id">identyfikator formy</param>
    public override void MarkMoldIncomplete(int id)
    {
        GetManager().SetMoldIncomplete(id);
    }

    /// <summary>
    /// Pobiera singleton fabryki.
    /// </summary>
    /// <returns>singleton fabryki; metoda nieimplementowana</returns>
    public Factory GetFactory()
    {
        return null;
    }
}