using System;
namespace Functions
{
    /// <summary>
    /// Opakowuje funkcj Math.Cos() wok podanego rda.
    /// </summary>
    public class Cos : Frapper 
    {
        /// <summary>
        /// Konstrukcja funkcji cosinusa doczanej do dostarczonej funkcji
        /// rdowej.
        /// </summary>
        /// <param name="f">Inna klasa opakowujca funkcj</param>
        public Cos(Frapper f) : base (f)
        {
        }
        /// <summary>
        /// Zwraca wynik wykonania Math.Cos() na wartoci funkcji rdowej
        /// w momencie t.
        /// </summary>
        /// <param name="t">czas</param>
        /// <returns>cosinus wartoci funkcji rdowej w momencie t</returns>
        public override double F(double t)
        {
            return Math.Cos(_sources[0].F(t));
        }
    }
}
