using System;

namespace Fireworks
{
	/// <summary>
   /// Fajerwerk wystrzeliwany z modzierza i eksplodujcy wysoko na niebie.
	/// </summary>
	public class Shell : Firework
	{
        private double _muzzleVelocity;
        /// <summary>
        /// Tworzy pust petard.
        /// </summary>
        public Shell()
        {
        }
        /// <summary>
        /// Tworzy petard o podanych waciwociach.
        /// </summary>
        /// <param name="muzzleVelocity">Prdko wylotowa (w metrach na sekund)
        /// petardy opuszczajcej luf modzierza</param>
        /// Opis pozostaych parametrw w definicji nadklasy.
        public Shell (
            string name, double mass, decimal price, double muzzleVelocity) : 
            base (name, mass, price)
        {
            MuzzleVelocity = muzzleVelocity;
        }
        /// <summary>
        /// Prdko wylotowa (w metrach na sekund) petardy opuszczajcej 
        /// luf modzierza.
        /// </summary>
        public double MuzzleVelocity
        {
            get
            {
                return _muzzleVelocity;
            }
            set
            {
                _muzzleVelocity = value;
            }
        }
	}
}
