using System;
using Utilities;
namespace Enumerators
{
    /// <summary>
    /// "Enumeracja" licia, czyli pojedyncze jego zwrcenie.
    /// </summary>
    public class LeafEnumerator: ComponentEnumerator 
    {
        /// <summary>
        /// Utworzenie "enumeratora" dla bezdzietnego wza kompozytu.
        /// </summary>
        /// <param name="node">wze do przejcia</param>
        /// <param name="visited">zbir odwiedzonych wzw</param>
        public LeafEnumerator(Object node, Set visited) : base(node, visited)
        {        
        }

        /// <summary>
        /// Zwraca zero, gdy gboko iteratora poniej licia jest
        /// zawsze rwna zero.
        /// </summary>
        /// <returns>zero, gdy gboko iteratora poniej licia jest
        /// zawsze rwna zero</returns>
        public override int Depth()
        {
            return 0;
        }

        /// <summary>
        /// Ustawienie wza jako biecego, jeli jeszcze na nim nie jestemy.
        /// W przeciwnym razie zwraca false.
        /// </summary>
        /// <returns>true jeli jeszcze nie jestemy na tym wle</returns>
        public override bool MoveNext()
        {
            if (_visited.Contains(_head))
            {
                _current = null;
                return false;
            }
            _visited.Add(_head);
            _current = _head;
            return true;
        }
    }
}
