using System;
using System.Collections;
using Utilities;
namespace Enumerators
{
    /// <summary>
    /// Iteracja po komponencie posiadajcym potomkw.
    /// </summary>
    public class CompositeEnumerator : ComponentEnumerator 
    {
        protected IEnumerator _childEnumerator;
        protected ComponentEnumerator _subEnumerator;
        /// <summary>
        /// Utworzenie enumeratora nad komponentem posiadajcym potomkw.
        /// </summary>
        /// <param name="node">wze do przechodzenia</param>
        /// <param name="children">wzy potomne</param>
        /// <param name="visited">zbir do zapisywania odwiedzonych wzw</param>
        public CompositeEnumerator(Object node, IList children, Set visited) : base (node, visited)
        {
            _childEnumerator = children.GetEnumerator();
        }
        /// <summary>
        /// Zwraca biec gboko iteracji. Iteratory przechodz drzewo
        /// w gb, wic gboko iteracji to gboko poprzedniej iteracji
        /// plus jeden.
        /// </summary>
        /// <returns>biec gboko iteracji (tzn. ilo wzw nad biecym)</returns>
        public override int Depth()
        {
            if (_subEnumerator != null)
            {
                return _subEnumerator.Depth() + 1;
            }
            return 0;
        }
        /// <summary>
        /// Przesunicie enumeratora.
        /// </summary>
        /// <returns>true jeli dostpny jest kolejny wze</returns>
        public override bool MoveNext()
        {
            if (!_visited.Contains(_head))
            {
                _visited.Add(_head);
                if (ReturnInterior)
                {
                    _current = _head;
                    return true;
                }
            }
            return SubenumeratorNext();
        }
        /// <summary>
        /// Na og metoda po prostu przechodzi do nastpnego elementu
        /// poprzedniego iteratora, jednak jeli takowy nie istnieje lub
        /// nie ma nastpnego elementu, metoda tworzy enumerator dla 
        /// nastpnego potomka (jeli go nie ma, zwracane jest false)
        /// i zwraca nastpny element tego enumeratora. 
        /// </summary>
        /// <returns>true jeli dostpny jest kolejny wze</returns>
        protected bool SubenumeratorNext()
        {
            while (true)
            {
                if (_subEnumerator != null)
                {
                    if (_subEnumerator.MoveNext())
                    {
                        _current = _subEnumerator.Current;
                        return true;
                    }
                }
                if (!_childEnumerator.MoveNext())
                {
                    _current = null;
                    return false;
                }
                ICompositeEnumerable c = (ICompositeEnumerable) _childEnumerator.Current;
                if (!_visited.Contains(c))
                {
                    _subEnumerator = c.GetEnumerator(_visited);
                    _subEnumerator.ReturnInterior = ReturnInterior;
                }
            }
        }
    }
}
