using System;
using System.Data;
using System.Data.OleDb;
using System.Collections;
using System.Reflection;

/// Klasa utworzona wycznie w celu sprawdzenia uycia interfejsu zamiast
/// delegacji BorrowReader.

namespace DataLayer
{
    /// <summary>
    /// Udostpnia podstawowe usugi dostpu do bazy Oozinoz. Przeksztacenie
    /// pokazuje sposb zastpienia delegacji interfejsem.
    /// </summary>
    public class DataServices2
    {
        /// <summary>
        /// Tworzy obiekt czytajcy na podstawie dostarczonego zapytania SQL,
        /// wykonuje metod BorrowReader dostarczonego obiektu IBorrower 
        /// i zamyka obiekt czytajcy.
        /// </summary>
        /// <param name="sql">Wykonywane zapytanie SQL.</param>
        /// <param name="borrower">Obiekt implementujcy IBorrower.</param>
        /// <returns>Warto zwracana przez dostarczon metod.</returns>
        public static object LendReader2(string sql, IBorrower borrower) 
        {
            using (OleDbConnection conn = DataServices.CreateConnection())
            {
                conn.Open(); 
                OleDbCommand c = new OleDbCommand(sql, conn);  
                OleDbDataReader r = c.ExecuteReader();
                return borrower.BorrowReader(r);
            }     
        }
    }
}
