using System;

namespace Controllers
{
    /// <summary>
    /// Meneder maszyny adaptujcy wsplny interfejs klasy MachineManager
    /// do konkretnego protokou komunikacyjnego maszyny do montau lontw.
    /// </summary>
    public class FuserManager : MachineManager
    {
        private FuserController _controller = new FuserController();
        public override void StartMachine() 
        {
            _controller.StartMachine();
        }
        public override void StopMachine() 
        {
            _controller.StopMachine();
        }
        public override void StartProcess() 
        {
            _controller.Begin();
        }
        public override void StopProcess() 
        {
            _controller.End();
        }
        public override void ConveyIn() 
        {
            _controller.ConveyIn();
        }
        public override void ConveyOut() 
        {
            _controller.ConveyOut();
        }
        public void SwitchSpool()
        {
            _controller.SwitchSpool();
        }
    }
}
