using System;

namespace Chemicals
{
    /// <summary>
    /// Klasa reprezentujca parti zwizku chemicznego.
    /// </summary>
    public class Substance2
    {
        private double _grams;
        private Chemical _chemical;

        /// <summary>
        /// Modeluje parti substancji. Klasa przeksztacona z pierwotnej
        /// klasy Substance tak, by zaleaa od niezmiennych obiektw klasy
        /// Chemical.
        /// </summary>
        /// <param name="grams">Masa tej partii substancji</param>
        /// <param name="chemical">Skad chemiczny partii</param>
        public Substance2 (double grams, Chemical chemical)
        {
            _grams = grams; 
            _chemical = chemical;
        }
        /// <summary>
        /// Nazwa substancji, na przykad "Saletra".
        /// </summary>
        public string Name
        {
            get
            {
                return _chemical.Name;
            }
        }
        /// <summary>
        /// Wzr chemiczny substancji, na przykad "KNO3".
        /// </summary>
        public string Symbol
        {
            get
            {
                return _chemical.Symbol;
            }
        }
        /// <summary>
        /// Masa atomowa substancji (dla saletry byoby to 101).
        /// </summary>
        public double AtomicWeight
        {
            get
            {
                return _chemical.AtomicWeight;
            }
        }
        /// <summary>
        /// Masa tej partii substancji.
        /// </summary>
        public double Grams
        {
            get
            {
                return _grams;
            }
        }
        /// <summary>
        /// Liczba moli w tej partii.
        /// </summary>
        public double Moles
        {
            get
            {
                return _grams / AtomicWeight;
            }
        }
    }
}
