namespace Carousel2
{
    /// <summary>
    /// Klasa modeluje zachowanie otwartych drzwi karuzeli.
    /// </summary>
    public class DoorOpen : DoorState 
    {
        /// <summary>
        /// Rozpoczcie zamykania, jeli drzwi s otwarte, a aparatura
        /// drzwi wyle sygna przekroczenia dopuszczalnego czasu.
        /// </summary>
        public override void Timeout(Door door)
        {
            door.SetState(DoorState.CLOSING);
        }

        /// <summary>
        /// Nieco nieintuicyjne zachowanie przycisku wielofunkcyjnego. Gdy
        /// drzwi s otwarte, zaczn si automatycznie zamyka po kilku 
        /// sekundach. Mona temu zapobiec jeszcze raz naciskajc przycisk,
        /// co zasygnalizuje, e drzwi maj pozosta otwarte.
        /// </summary>
        public override void Touch(Door door)
        {
            door.SetState(DoorState.STAYOPEN);
        }
    }
}
