namespace Carousel
{
    /// <summary>
    /// Modeluje zachowanie drzwi karuzeli, gdy otrzymaj polecenie
    /// otwarcia na stae.
    /// </summary>
    public class DoorStayOpen : DoorState 
    { 
        /// <summary>
        /// Konstrukcja stanu dostarczonych drzwi.
        /// </summary>
        /// <param name="door">drzwi wymagajce modelu stanu</param>
        public DoorStayOpen(Door2 door) : base (door)
        {
        }
        /// <summary>
        /// Zamknicie drzwi.
        /// </summary>
        public override void Touch()
        {
            _door.SetState(_door.CLOSING);
        }
    }
}
