using System;

namespace Carousel
{
	/// <summary>
	/// Nadklasa konkretnych stanw drzwi (na przykad DoorOpen). Klasa 
	/// definiuje interfejs klasy stanu drzwi i dostarcza zmienn instancji
	/// skadujc odwoanie do konkretnych drzwi.
	/// </summary>
	public abstract class DoorState
	{
		protected Door2 _door;

        /// <summary>
        /// Konstrukcja stanu dostarczonych drzwi.
        /// </summary>
        /// <param name="door">drzwi wymagajce modelu stanu</param>
        public DoorState(Door2 door)
        {
            _door = door;
        }

        /// <summary>
        /// Klasy potomne musz same zdecydowa o dziaaniu podejmowanym
        /// w chwili nacinicia przycisku karuzeli przez uytkownika.
        /// </summary>
        public abstract void Touch();

        /// <summary>
        /// Powiadomienia o zakoczeniu otwierania lub zamykania drzwi s
        /// domylnie ignorowane.
        /// </summary>
        public virtual void Complete()
        {
        }

        /// <summary>
        /// Powiadomienia o rozpoczciu zamykania z powodu przekroczenia
        /// czasu otwarcia s domylnie ignorowane.
        /// </summary>
        public virtual void Timeout()
        {
        }

        /// <summary>
        /// Zwraca tekstowy opis biecego stanu.
        /// </summary>
        /// <returns>tekstowy opis biecego stanu</returns>
        public String Status()
        {
            return this.GetType().Name;
        }
	}    
}
