namespace Carousel
{
    /// <summary>
    /// Klasa modeluje zachowanie zamykajcych si drzwi karuzeli.
    /// </summary>
    public class DoorClosing : DoorState 
    {
        /// <summary>
        /// Konstrukcja stanu dostarczonych drzwi.
        /// </summary>
        /// <param name="door">drzwi wymagajce modelu stanu</param>
        public DoorClosing(Door2 door) : base (door)
        {
        }

        /// <summary>
        /// Drzwi zostay zamknite.
        /// </summary>
        public override void Complete()
        {
            _door.SetState(_door.CLOSED);
        }

        /// <summary>
        /// Otwarcie drzwi.
        /// </summary>
        public override void Touch()
        {
            _door.SetState(_door.OPENING);
        }
    }
}
