namespace Aster 
{
    public delegate void AsterHook(AsterStarPress2 p);
    /// <summary>
    /// Zmodyfikowana wersja klasy AsterStarPress, wprowadzajca
    /// wzorzec Command w celu umoliwienia klientowi wpywania na jej
    /// zachowanie.
    /// 
    /// Klasa opisana w rozdziale Command. 
    /// </summary>
    public class AsterStarPress2
    {
        public event AsterHook MoldIncomplete;
        protected int _currentMoldID;

        /// <summary>
        /// Identyfikator aktualnie przetwarzanej formy.
        /// </summary>
        public int CurrentMoldID
        {
            get
            {
                return _currentMoldID;
            }
        }

        /// <summary>
        /// Wyrzuca ca past uywan do tworzenia gwiazd do mietnika.
        /// </summary>
        public virtual void DischargePaste()
        {
        }

        /// <summary>
        /// Zlanie wod powierzchni roboczej i dysz z past w celu utrzymania
        /// czystoci maszyny.
        /// </summary>
        public virtual void Flush()
        {
        }

        /// <summary>
        /// Zwraca true jeli maszyna aktualnie przetwarza form.
        /// </summary>
        /// <returns>true jeli maszyna aktualnie przetwarza form</returns>
        public virtual bool InProcess()
        {
            return false;
        }

        /// <summary>
        /// Konkretny sposb radzenia sobie przez fabryk z niekompletnie
        /// przetworzon form zostanie zaimplementowany w klasach
        /// dziedziczcych.
        /// </summary>
        public virtual void ShutDown()
        {
            if (InProcess())
            {
                StopProcessing();
                if (MoldIncomplete != null) 
                {
                    MoldIncomplete(this); 
                }
            }
            UsherInputMolds();
            DischargePaste();
            Flush();
        }

        /// <summary>
        /// Wstrzymanie przetwarzania.
        /// </summary>
        public virtual void StopProcessing()
        {
        }

        /// <summary>
        /// Przesunicie wszystkich form na tam wyjciow.
        /// </summary>
        public virtual void UsherInputMolds()
        {
        }
    }
}
