using System;

public delegate void ChangeHandler();

/// <summary>
/// Klasa wykorzystywana w rozdziale Observer, posiadajca metod Wiggle().
/// </summary>
class Interesting
{
    // Warto zauway, e Change i Change2 obie s zmiennymi instancji typu
    // delegowanego ChangeHandler. Jedyna rnica midzy nimi polega na tym,
    // e Change2 jest dodatkowo oznaczona jako zdarzenie.
    public ChangeHandler Change;
    public event ChangeHandler Change2;
    public void Wiggle()
    {
        if (Change != null) Change();
        if (Change2 != null) Change2();
    }
}
/// <summary>
/// Klasa ta jest w rozdziale Observer uywana do pokazania sposobu
/// rejestrowania klienta do wywoa zwrotnych w momencie wprowadzenia 
/// zmian w interesujcej klasie.
/// </summary>
class Curious
{
    public Curious(Interesting i)
    {
        i.Change += new ChangeHandler(React);
    }
    public void React()
    {
        Console.WriteLine("Co si stao!");
    }
}