using System;
using Functions;
using UserInterface;

/// <summary>
/// Klasa dziedziczca z PlotPanel, nasuchujca zdarze Change zgaszanych
/// przez obiekt ValueHolder.
/// </summary>
public class AlertPlotPanel : PlotPanel
{
    /// <summary>
    /// Tworzy nasuchujcy zmian panel wykresu.
    /// </summary>
    /// <param name="nPoint">ilo nanoszonych punktw</param>
    /// <param name="tf">nanoszona funkcja</param>
    public AlertPlotPanel(int nPoint, TpeakFunction tf, Tpeak tp) : 
        base (nPoint, new Function(tf.F))
    {
        tp.Change += new ChangeHandler(FunctionChange);
    }
    private void FunctionChange()
    {
        Refresh();
    }
}