﻿List<Dog> dogs = [
            new Dog(Breeds.Jamnik, "Franz"),
            new Dog(Breeds.Collie, "Petunia"),
            new Dog(Breeds.Mastif, "Pepperoni"),
            new Dog(Breeds.Jamnik, "Brunhilda"),
            new Dog(Breeds.Malinois, "Zippy"),
            new Dog(Breeds.Collie, "Carrie"),
];

dogs.Sort();
foreach (Dog dog in dogs)
    Console.WriteLine(dog);

enum Breeds
{
    Collie = 3,
    Malinois = -9,
    Jamnik = 7,
    Mastif = 0,
}

class Dog(Breeds breed, string name) : IComparable<Dog>
{
    public Breeds Breed { get { return breed; } }

    public string Name { get { return name; } }

    public int CompareTo(Dog? other)
    {
        if (other == null) return 0;
        if (Breed > other.Breed) return -1;
        if (Breed < other.Breed) return 1;
        return -Name.CompareTo(other.Name);
    }

    public override string ToString()
    {
        return $"{Breed} o imieniu {Name}";
    }
}
