﻿using System;

namespace Chapter14
{
    class OverloadResolution
    {
        static void Method1<T>(object x) where T : struct =>
            Console.WriteLine($"{typeof(T)} jest strukturą");

        static void Method1<T>(string x) where T : class =>
            Console.WriteLine($"{typeof(T)} jest typem referencyjnym");

        static void Method2(object x) =>
            Console.WriteLine("Metoda statyczna");

        void Method2(string x) =>
            Console.WriteLine("Metoda instancji");

        void Method3(object x) =>
            Console.WriteLine("Metoda instancji");

        static void Method3(string x) =>
            Console.WriteLine("Metoda statyczna");

        static void Main()
        {
            // Wersja z parametrem string jest lepsza, ale int narusza ograniczenie "where T : struct"
            Method1<int>("tekst");

            // Wersja z parametrem string jest lepsza, ale nie można wywołać metody instancji w statycznym
            // kontekście bez podania referencji.
            Method2("tekst");

            // Wersja z parametrem string jest lepsza, ale nie można wywołać metody statycznej dla referencji.
            var instance = new OverloadResolution();
            instance.Method3("tekst");
        }
    }
}
