﻿using System;

namespace Chapter13
{
    // Przykład pokazujący, w jaki sposób niezabezpieczony kod może naruszać modyfikator readonly.

    readonly struct EvilStruct
    {
        public int Value { get; }

        public EvilStruct(int value) => Value = value;

        public unsafe void Mutate(int newValue)
        {
            fixed (EvilStruct* me = &this)
            {
                *me = new EvilStruct(newValue);
            }
        }
    }

    class ReadonlyStructUnsafeViolation
    {
        private static readonly EvilStruct evil = new EvilStruct(10);

        static void Main()
        {
            Console.WriteLine(evil.Value);
            evil.Mutate(20);
            Console.WriteLine(evil.Value);
        }
    }
}
