﻿using System;
using System.Runtime.CompilerServices;

namespace Chapter07
{
    class CallerNameCornerCases
    {
        static void ShowCallerName(string manualCaller, [CallerMemberName] string name = "(nieokreślona)")
        {
            Console.WriteLine("Jednostka wywołująca {0}, podane przez kompilator: {1}", manualCaller, name);
        }

        ~CallerNameCornerCases()
        {
            ShowCallerName("finalizator");
        }

        CallerNameCornerCases()
        {
            ShowCallerName("konstruktor");
        }

        public int this[int x]
        {
            get
            {
                ShowCallerName("indekser");
                return 10;
            }
        }

        public static implicit operator string(CallerNameCornerCases x)
        {
            ShowCallerName("konwersja");
            return "";
        }        

        public static CallerNameCornerCases operator +(CallerNameCornerCases lhs, int rhs)
        {
            ShowCallerName("operator");
            return lhs;
        }        

        static void Main()
        {
            var tmp = new CallerNameCornerCases();
            tmp = tmp + 1;
            int xy = tmp[20];
            string y = tmp;
            tmp = null;
            GC.Collect();
            GC.WaitForPendingFinalizers();
        }
    }
}
