﻿using System;
using System.ComponentModel;

namespace Chapter02
{
    class GenericCounter<T>
    {
        private static int value;

        static GenericCounter()
        {
            Console.WriteLine("Inicjalizowanie licznika dla typu {0}", typeof(T));
        }

        public static void Increment()
        {
            value++;
        }

        public static void Display()
        {
            Console.WriteLine("Licznik dla typu {0}: {1}", typeof(T), value);
        }
    }

    [Description("Listing 2.8")]
    class GenericCounterDemo
    {
        static void Main()
        {
            GenericCounter<string>.Increment();
            GenericCounter<string>.Increment();
            GenericCounter<string>.Display();
            GenericCounter<int>.Display();
            GenericCounter<int>.Increment();
            GenericCounter<int>.Display();
        }
    }
}
