﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Dynamic;

namespace Chapter04
{
    [Description("Listing 4.5")]
    class ExpandoObjectIntroduction
    {
        static void Main()
        {
            dynamic expando = new ExpandoObject();
            expando.SomeData = "Jakieś dane";
            Action<string> action = input => Console.WriteLine("Dane wejściowe to '{0}'", input);
            expando.FakeMethod = action;

            Console.WriteLine(expando.SomeData);
            expando.FakeMethod("witaj");

            IDictionary<string, object> dictionary = expando;
            Console.WriteLine("Klucze: {0}", string.Join(", ", dictionary.Keys));

            dictionary["OtherData"] = "Inne dane";
            Console.WriteLine(expando.OtherData);
        }
    }
}
