﻿using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace Chapter06
{
    [Description("Listing 6.5")]
    class IteratorWorkflow
    {
        static readonly string Padding = new string(' ', 30);

        static IEnumerable<int> CreateEnumerable()
        {
            Console.WriteLine("{0}Początek CreateEnumerable()", Padding);

            for (int i = 0; i < 3; i++)
            {
                Console.WriteLine("{0}Gotowy do wydania {1}", Padding, i);
                yield return i;
                Console.WriteLine("{0}Po wydaniu", Padding);
            }

            Console.WriteLine("{0}Wydawanie ostatniej wartości", Padding);
            yield return -1;

            Console.WriteLine("{0}Koniec CreateEnumerable()", Padding);
        }

        static void Main()
        {
            IEnumerable<int> iterable = CreateEnumerable();
            IEnumerator<int> iterator = iterable.GetEnumerator();

            Console.WriteLine("Rozpoczynanie iteracji");
            while (true)
            {
                Console.WriteLine("Wywołanie MoveNext()...");
                bool result = iterator.MoveNext();
                Console.WriteLine("... MoveNext wynik={0}", result);
                if (!result)
                {
                    break;
                }
                Console.WriteLine("Pobieranie Current...");
                Console.WriteLine("... Current wynik={0}", iterator.Current);
            }
        }
    }
}
