﻿using System.Diagnostics.Contracts;

namespace Chapter15
{
    class SimpleStaticChecking
    {
        static string DontPassMeNull(string input)
        {
            Contract.Requires(input != null);
            Contract.Ensures(Contract.Result<string>() != null);
            return input;
        }

        static string MightReturnNull()
        {
            return "W rzeczywistości nie null";
        }

        static void Main(string[] args)
        {
            DontPassMeNull("zdecydowanie dobrze");
            DontPassMeNull(MightReturnNull());
            DontPassMeNull(null);            
        }
    }
}
