using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Web.Services;
using System.Web.Services.Protocols;
// compile: csc /t:winexe /r:amazproxy.dll amazonform.cs
namespace AmazonApplication
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.TextBox textBox3;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ListView listView1;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Button button5;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Button button6;
		private System.Windows.Forms.Button button7;
		//
		int CurrPg;
		string SearchMode = "";
		int MaxPages =1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//

			InitializeComponent();
			//
			listView1.SelectedIndexChanged += new EventHandler(lv_IndexChanged);
			listView1.FullRowSelect = true;
			listView1.GridLines = true;
			listView1.Columns.Add("Tytu",200,HorizontalAlignment.Left);
			listView1.Columns.Add("Autor",100,HorizontalAlignment.Left);
			listView1.Columns.Add("Cena",60, HorizontalAlignment.Left);
			listView1.Columns.Add("Ocena",50,HorizontalAlignment.Left);
			listView1.Columns.Add("Data wydania",120,HorizontalAlignment.Left);

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		//**** Place your Developer's tag here
		private string getDevTag()
		{
		  // Umie tutaj swj znacznik
		  string devTag= "0SD6PAP6H2V5G3SDSJR2";  // example
		  return(devTag);
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.button1 = new System.Windows.Forms.Button();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.button5 = new System.Windows.Forms.Button();
            this.button4 = new System.Windows.Forms.Button();
            this.button3 = new System.Windows.Forms.Button();
            this.label3 = new System.Windows.Forms.Label();
            this.textBox3 = new System.Windows.Forms.TextBox();
            this.textBox2 = new System.Windows.Forms.TextBox();
            this.label2 = new System.Windows.Forms.Label();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.button2 = new System.Windows.Forms.Button();
            this.listView1 = new System.Windows.Forms.ListView();
            this.label4 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.button6 = new System.Windows.Forms.Button();
            this.button7 = new System.Windows.Forms.Button();
            this.groupBox1.SuspendLayout();
            this.SuspendLayout();
            // 
            // button1
            // 
            this.button1.Location = new System.Drawing.Point(256, 24);
            this.button1.Name = "button1";
            this.button1.Size = new System.Drawing.Size(48, 24);
            this.button1.TabIndex = 0;
            this.button1.Text = "Szukaj";
            this.button1.Click += new System.EventHandler(this.button1_Click);
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.button5);
            this.groupBox1.Controls.Add(this.button4);
            this.groupBox1.Controls.Add(this.button3);
            this.groupBox1.Controls.Add(this.label3);
            this.groupBox1.Controls.Add(this.textBox3);
            this.groupBox1.Controls.Add(this.textBox2);
            this.groupBox1.Controls.Add(this.label2);
            this.groupBox1.Controls.Add(this.textBox1);
            this.groupBox1.Controls.Add(this.label1);
            this.groupBox1.Controls.Add(this.button2);
            this.groupBox1.Controls.Add(this.button1);
            this.groupBox1.Location = new System.Drawing.Point(16, 16);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(416, 120);
            this.groupBox1.TabIndex = 1;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Wyszukiwanie";
            // 
            // button5
            // 
            this.button5.Location = new System.Drawing.Point(310, 76);
            this.button5.Name = "button5";
            this.button5.Size = new System.Drawing.Size(100, 36);
            this.button5.TabIndex = 10;
            this.button5.Text = "Wyszukiwanie zoone";
            this.button5.Click += new System.EventHandler(this.button5_Click);
            // 
            // button4
            // 
            this.button4.Location = new System.Drawing.Point(256, 88);
            this.button4.Name = "button4";
            this.button4.Size = new System.Drawing.Size(48, 24);
            this.button4.TabIndex = 9;
            this.button4.Text = "Szukaj";
            this.button4.Click += new System.EventHandler(this.button4_Click);
            // 
            // button3
            // 
            this.button3.Location = new System.Drawing.Point(256, 56);
            this.button3.Name = "button3";
            this.button3.Size = new System.Drawing.Size(48, 24);
            this.button3.TabIndex = 8;
            this.button3.Text = "Szukaj";
            this.button3.Click += new System.EventHandler(this.button3_Click);
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(16, 88);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(32, 16);
            this.label3.TabIndex = 7;
            this.label3.Text = "Tytu";
            // 
            // textBox3
            // 
            this.textBox3.Location = new System.Drawing.Point(122, 88);
            this.textBox3.Name = "textBox3";
            this.textBox3.Size = new System.Drawing.Size(128, 20);
            this.textBox3.TabIndex = 6;
            // 
            // textBox2
            // 
            this.textBox2.Location = new System.Drawing.Point(122, 56);
            this.textBox2.Name = "textBox2";
            this.textBox2.Size = new System.Drawing.Size(128, 20);
            this.textBox2.TabIndex = 5;
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(16, 56);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(40, 16);
            this.label2.TabIndex = 4;
            this.label2.Text = "Autor";
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(122, 24);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(128, 20);
            this.textBox1.TabIndex = 3;
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(16, 24);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(100, 20);
            this.label1.TabIndex = 2;
            this.label1.Text = "Sowo kluczowe";
            // 
            // button2
            // 
            this.button2.Location = new System.Drawing.Point(310, 24);
            this.button2.Name = "button2";
            this.button2.Size = new System.Drawing.Size(82, 32);
            this.button2.TabIndex = 1;
            this.button2.Text = "Wyczy";
            this.button2.Click += new System.EventHandler(this.button2_Click);
            // 
            // listView1
            // 
            this.listView1.Location = new System.Drawing.Point(16, 176);
            this.listView1.Name = "listView1";
            this.listView1.Size = new System.Drawing.Size(472, 112);
            this.listView1.TabIndex = 2;
            this.listView1.UseCompatibleStateImageBehavior = false;
            this.listView1.View = System.Windows.Forms.View.Details;
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(448, 160);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(40, 16);
            this.label4.TabIndex = 3;
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(24, 160);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(88, 16);
            this.label5.TabIndex = 4;
            // 
            // label6
            // 
            this.label6.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.label6.Location = new System.Drawing.Point(16, 320);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(472, 16);
            this.label6.TabIndex = 5;
            // 
            // button6
            // 
            this.button6.Location = new System.Drawing.Point(456, 296);
            this.button6.Name = "button6";
            this.button6.Size = new System.Drawing.Size(32, 16);
            this.button6.TabIndex = 6;
            this.button6.Text = "-->";
            this.button6.Click += new System.EventHandler(this.button6_Click);
            // 
            // button7
            // 
            this.button7.Location = new System.Drawing.Point(408, 296);
            this.button7.Name = "button7";
            this.button7.Size = new System.Drawing.Size(32, 16);
            this.button7.TabIndex = 7;
            this.button7.Text = "<--";
            this.button7.Click += new System.EventHandler(this.button7_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(520, 357);
            this.Controls.Add(this.button7);
            this.Controls.Add(this.button6);
            this.Controls.Add(this.label6);
            this.Controls.Add(this.label5);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.listView1);
            this.Controls.Add(this.groupBox1);
            this.Name = "Form1";
            this.Text = "Klient usug Web Amazonu";
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Punkt wejcia do aplikacji
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		} 

		private void button1_Click(object sender, System.EventArgs e)
		{
			int tempPage = CurrPg;
			CurrPg=1;
            // Zmienia stan zmiennych jeli danie si powiedzie
			if (KeywordReq()) 
			{
				SearchMode="keyword";
			}
			else 
			{
				CurrPg = tempPage;
			}
		}
		private bool KeywordReq()
		{
			AmazonSearchService amazon = new AmazonSearchService();
			KeywordRequest kwRequest = new KeywordRequest();
			//kwRequest.keyword = "butterflies";
			kwRequest.keyword = textBox1.Text;
			kwRequest.type = "heavy";
			kwRequest.devtag= getDevTag();
			kwRequest.mode = "books";
			kwRequest.tag = "webservices-20";
			kwRequest.page = CurrPg.ToString();
			try 
			{
				ProductInfo products = amazon.KeywordSearchRequest(kwRequest);
				FillListView(products);		
				return(true);
			} 
			catch (SoapException ex)
			{
				MessageBox.Show(ex.Message);
				return(false);
			}
		}
		private void button2_Click(object sender, System.EventArgs e)
		{
			textBox1.Text="";
			textBox2.Text="";
			textBox3.Text="";
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			int tempPage = CurrPg;
			CurrPg=1;
			if (AuthorReq()) 
			{
				SearchMode="author";
			}
			else 
			{
				CurrPg = tempPage;
			}
		}
		private bool AuthorReq()
		{
			AmazonSearchService amazon = new AmazonSearchService();
			AuthorRequest auRequest = new AuthorRequest();
			auRequest.author = textBox2.Text;
			auRequest.type = "heavy";
			auRequest.devtag= getDevTag();
			auRequest.mode = "books";
			auRequest.tag = "webservices-20";
			auRequest.page = CurrPg.ToString();
			try 
			{
				ProductInfo products = amazon.AuthorSearchRequest(auRequest);
				FillListView(products);	
				return(true);
			} 
			catch (SoapException ex)
			{
				MessageBox.Show(ex.Message);	
				return(false);
			}
		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			int tempPage = CurrPg;
			CurrPg = 1;
            // Zmienia stan zmiennych jeli danie si powiedzie
			if (TitleReq()) 
			{
				SearchMode="title";
			}
			else 
			{
				CurrPg = tempPage;
			}		
		}
		private bool TitleReq()
		{
			AmazonSearchService amazon = new AmazonSearchService();
			PowerRequest pRequest = new PowerRequest();
			pRequest.power= "title:"+ textBox3.Text;
			pRequest.type = "heavy";
			pRequest.devtag=  getDevTag();
			pRequest.mode = "books";
			pRequest.tag = "webservices-20";
			pRequest.page = CurrPg.ToString();
			try 
			{
				ProductInfo products = amazon.PowerSearchRequest(pRequest);
				FillListView(products);		
				return(true);
			} 
			catch (SoapException ex)
			{
				MessageBox.Show(ex.Message);		
				return(false);
			}
		}
		private void FillListView(ProductInfo products)
		{
			listView1.Items.Clear();
			label6.Text="";
			label4.Text = products.TotalResults;
			label5.Text = CurrPg.ToString()+" of "+products.TotalPages;
			MaxPages =  Convert.ToInt32(products.TotalPages);
			ListViewItem rowItem; 
			string auth,rev;
			for (int i=0; i< products.Details.Length; i++)
			{ 
				//listView1.Items.Add(products.Details[i].ProductName );
				rowItem = new ListViewItem(products.Details[i].ProductName);
				object ob = products.Details[i].Authors;
				if (ob != null)  auth = products.Details[i].Authors[0]; else auth="None";
				rowItem.SubItems.Add(auth);
				rowItem.SubItems.Add(products.Details[i].OurPrice);
				ob = products.Details[i].Reviews;
				if (ob != null)  rev = products.Details[i].Reviews.AvgCustomerRating; else rev="None";
				rowItem.SubItems.Add(rev);
				rowItem.SubItems.Add(products.Details[i].ReleaseDate);
				listView1.Items.Add(rowItem);
			}
		}
		private void lv_IndexChanged(object sender, System.EventArgs e)
		{
			label6.Text = listView1.FocusedItem.Text;

		}

		private void button6_Click(object sender, System.EventArgs e)
		{
			// Strona nastpna
			if (CurrPg < MaxPages) 
			{
				CurrPg += 1;
				label6.Text="";
				if (SearchMode== "title") TitleReq();
				if (SearchMode== "author") AuthorReq();
				if (SearchMode== "keyword") KeywordReq();
				if (SearchMode== "power") PowerReq();

			}
		}

		private void button7_Click(object sender, System.EventArgs e)
		{
            // Strona poprzednia
			if (CurrPg >0) 
			{
				CurrPg -= 1;
				label6.Text="";
				if (SearchMode== "title") TitleReq();
				if (SearchMode== "author") AuthorReq();
				if (SearchMode== "keyword") KeywordReq();
				if (SearchMode== "power") PowerReq();

			}
		}

		private void button5_Click(object sender, System.EventArgs e)
		{
			// Przeszukiwanie
			int tempPage = CurrPg;
			CurrPg = 1;
			// Zmienia stan zmiennych jeli danie si powiedzie
			if (PowerReq()) 
			{
				SearchMode="power";
			}
			else 
			{
				CurrPg = tempPage;
			}		
		}
		private bool PowerReq()
		{
			string kw="";
			string au="";
			string ti="";
			AmazonSearchService amazon = new AmazonSearchService();
			PowerRequest pRequest = new PowerRequest();
			if (textBox1.Text != "") kw = "keywords:"+textBox1.Text;
			if (textBox2.Text != "")  au = "author:"+textBox2.Text;
			if (textBox3.Text != "") ti = "title:"+textBox3.Text;
			string query="";
			query = kw;
			if (au !="") 
			{
				if (kw == "") query= au; else query = kw +" AND "+au;
			}
			if (ti !="") 
			{
				if(query =="") query= ti; else query = query + " AND "+ti;
			}
			//pRequest.power= "title:"+ textBox3.Text;
			pRequest.power = query;
			pRequest.type = "heavy";
			pRequest.devtag= getDevTag();
			pRequest.mode = "books";
			pRequest.tag = "webservices-20";
			pRequest.page = CurrPg.ToString();
			try 
			{
				ProductInfo products = amazon.PowerSearchRequest(pRequest);
				FillListView(products);		
				return(true);
			} 
			catch (SoapException ex)
			{
				MessageBox.Show(ex.Message);		
				return(false);
			}
		}
	}
}
