using System;
using System.Reflection;
using AppDomainTest; 
// Kompilacja: csc /r:appdtestclass.dll appdtestclient.cs
public class AppDomainClient
{
  static void Main()
  {
      AppDomain currentAppDomain;
      currentAppDomain = AppDomain.CurrentDomain;
      RemoteClass rc;
       // rc= new RemoteClass();
       // rc.ShowDomain();
      // (1) Tworzy obiekt klasy RemoteClass znajdujcej si w zestawie appdtestclass
      rc = (RemoteClass)currentAppDomain.CreateInstanceAndUnwrap("appdtestclass",
       	    "AppDomainTest.RemoteClass");
      // (2) Wywouje metod z klasy znajdujcej si w innej domenie
      rc.ShowDomain();  
      // (3) Wywietla zestawy znajdujce si w aktualnej domenie aplikacji
      Assembly[] currAssemblies = currentAppDomain.GetAssemblies();
      ShowAssemblies (currAssemblies);
       
      // (4) Tworzy now domen aplikacji
      AppDomain myAppDomain = AppDomain.CreateDomain("Nowa domena");
      rc =(RemoteClass)myAppDomain.CreateInstanceAndUnwrap("appdtestclass", 
              "AppDomainTest.RemoteClass");
      rc.ShowDomain();
      // (5) Wywietla zestawy nowej domeny
      currAssemblies = myAppDomain.GetAssemblies();
      ShowAssemblies(currAssemblies);
      //
      Console.Write("Wtek"+System.Threading.Thread.GetDomain().FriendlyName);
      //
      AppDomain.Unload(myAppDomain);
     Console.Read();
       
  }
     
     private static void ShowAssemblies(Assembly[] currAssemblies)
     {
        foreach(Assembly a in currAssemblies) 
        {
           	Console.WriteLine(" Nazwa zestawu: {0}",a.GetName().Name);
        }
     }
 }