using System;
using System.Collections;
using System.Threading;
using System.IO;
using System.Drawing;
namespace ThreadExample
{
    class SimpleClient
    {
        static void Main(string[] args)
        {
            Threader t = new Threader();
            Console.Read();
        }
    }
    class Threader
    {
        ImageServer server;
        public Threader()
        {
            server = new ImageServer();
            StartThreader();
        }
        public void StartThreader()
        {
            // W ptli powstaje siedem wtkw do pobierania rysunkw
            for (int i = 0; i < 7; i++)
            {
                //(1) Tworzenie delegacji
                ThreadStart threadStart = new ThreadStart(FetchImage);
                //(2) Tworzenie wtku
                Thread workerThread = new Thread(threadStart);
                //(3) Ustawianie jednego z dwch priorytetw dla porwnania ich dziaania
                if (i % 2 == 1)
                    workerThread.Priority = ThreadPriority.Lowest;
                else
                    workerThread.Priority = ThreadPriority.AboveNormal;
                //(4) Uruchomienie wtku
                workerThread.Start();
            }
        }
        public void FetchImage()
        {
            // Identyfikacja watku
            Console.WriteLine("Wtek" + Thread.CurrentThread.GetHashCode());
            string[] posters =  { "afi1.gif", "afi2.gif", "afi6.gif", "afi7.gif", "afi8.gif" };
            // Kady wtek pobiera pi rysunkw
            // ImageServer server= new ImageServer();
            Monitor.Enter(server);
            try
            {
                for (int i = 0; i < 5; i++)
                {
                    byte[] imgArray = server.GetMovieImage(posters[i],
                       Thread.CurrentThread.GetHashCode());
                    MemoryStream ms = new MemoryStream(imgArray);
                    Bitmap bmp = new Bitmap(ms);
                }
            }
            catch (Exception ex)
            { Console.WriteLine(ex.Message); }
            Monitor.Exit(server);
        }	// FetchImage
    }    // Threader


    public class ImageServer
    {
        public byte[] GetMovieImage(string imageName, int threadNum)
        {
            // Zwraca dany rysunek do klienta w postaci strumienia bajtw
            // i wywietla numer wywoujcego wtku
            int imgByte;
            imageName = "\\obrazy\\" + imageName;
            // Jeli plik jest niedostpny, program zgasza wyjtek przechwytywany przez klienta
            FileStream s = File.OpenRead(imageName);
            MemoryStream ms = new MemoryStream();
            while ((imgByte = s.ReadByte()) != -1)
            {
                ms.WriteByte(((byte)imgByte));
            }
            // Wywietla kolejno dziaania wtkw
            Console.WriteLine("Wtek: {0}", threadNum);
            return ms.ToArray();
        }
    }

}	  // Simpleclient