using System;
using System.Text;  
using System.Threading;
// Asynchroniczna delegacja (Listing 13.1)
   public class Async
   {   
      // Kod zwracajcy warto indeksu masy ciaa (BMI)
      private delegate decimal bmiDelegate(decimal ht, decimal wt);
      decimal ht_in = 72;
      decimal wt_lbs = 168;
      // (1) Asynchroniczne wywoanie delegacji
      bmiDelegate bd = new bmiDelegate(CalcBMI);
      IAsyncResult asRes = bd.BeginInvoke(ht_in, wt_lbs, null, null);
      int numPolls = 0;
      while (!asRes.IsCompleted)
      {
         // Wykonuje potrzebne operacje
         // (2) Oczekuje 20 milisekund na sygna zakoczenia dziaania metody
         asRes.AsyncWaitHandle.WaitOne(20, false);
         numPolls += 1;
      }
      // (3) Pobiera wynikw po zakoczeniu dziaania asynchronicznej metody
      decimal myBMI = bd.EndInvoke(asRes);
      Console.WriteLine("Sprawdzanie: {0} BMI: {1.##,00}",
      numPolls, myBMI); // --> Sprawdzanie: 3 BMI: 22,78
      // Oblicza BMI
      private decimal CalcBMI(decimal ht, decimal wt)
      {
         Thread.Sleep(200); // Symulacja opnienia 200 ms
         Console.WriteLine("Wtek: {0}",
            Thread.CurrentThread.GetHashCode());
         return((wt * 703 * 10/(ht*ht))/10);
      }
}