using System;
using System.Windows.Forms;
using System.Drawing;
// Kompilacja: csc /t:winexe datagridview.cs
class MyWinApp
{
    static void Main()
    {
        // (1) Tworzy formularz i wywouje go
        Form mainForm = new SimpleForm();
        Application.Run(mainForm);
    }
}

// Formularz uytkownika dziedziczcy po klasie bazowej Form
class SimpleForm : Form
{
    private Button button1;
    DataGridView dataGridView1;
    public SimpleForm()
    {
        this.Text = "DataGridView";
        this.Width = 360;
        this.Height = 220;
        dataGridView1 = new DataGridView();
        dataGridView1.Location = new Point(4, 4);
        dataGridView1.Size = new Size(348, 140);
        this.Controls.Add(dataGridView1);
        // (2) Tworzenie kontrolki button i ustawianie wybranych atrybutw
        button1 = new Button();
        button1.Location = new Point(96, 160);
        button1.Size = new Size(120, 24);
        button1.Text = "Zapenij kontrolk";
        this.Controls.Add(button1);
        // (3) Tworzenie delegacji wywoujcej procedur w wyniku kliknicia przycisku
        button1.Click += new EventHandler(button1_Click);
    }

    // Metoda ustawiajca waciwoci kontrolki DataGridView i zapeniajc j danymi
    private void CreateGrid()
    {
        if (dataGridView1.Rows.Count == 0)
        {
            // (1) Definiowanie nagwkw kolumn
            dataGridView1.ColumnCount = 3;
            dataGridView1.Columns[0].HeaderText = "Tytu filmu";
            dataGridView1.Columns[1].HeaderText = "Rok";
            dataGridView1.Columns[2].HeaderText = "Reyser";
            dataGridView1.Columns[1].Name = "Year";
            dataGridView1.Columns[0].Width = 150;
            dataGridView1.Columns[1].Width = 40;
            dataGridView1.Columns[2].Width = 110;
            // (2) Definiowanie stylu komrek z danymi
            DataGridViewCellStyle style = new DataGridViewCellStyle();
            style.BackColor = Color.Bisque;
            style.Font = new Font("Arial", 8, FontStyle.Bold);
            style.ForeColor = Color.Navy;
            //                         (left,top,right,bottom)
            style.Padding = new Padding(5, 2, 5, 5);
            style.SelectionBackColor = Color.LightBlue;
            dataGridView1.DefaultCellStyle = style;
            // (3) Definiowanie stylu komrek nagwkw
            DataGridViewCellStyle styleHdr = new
            DataGridViewCellStyle();
            styleHdr.Padding = new Padding(1, 1, 1, 1);
            styleHdr.BackColor = Color.OldLace;
            styleHdr.ForeColor = Color.Black;
            dataGridView1.ColumnHeadersDefaultCellStyle = styleHdr;
            // (4) Definiowanie moliwych dziaa uytkownika
            dataGridView1.AllowUserToAddRows = false;
            dataGridView1.AllowUserToOrderColumns = false;
            dataGridView1.AllowUserToDeleteRows = false;
            // (5) Samodzielne umieszczanie danych w tabelce (lepiej uy rda danych)
            object[] row1 = { "Casablanca", "1942", "Michael Curtiz" };
            dataGridView1.Rows.Add(row1);
            object[] row2 = { "Wcieky byk", "1980", "Martin Scorsese" };
            dataGridView1.Rows.Add(row2);
            object[] row3 = { "Na nabrzeach", "1954", "Elia Kazan" };
            dataGridView1.Rows.Add(row3);
            object[] row4 = { "P artem, p serio", "1959", "Billy Wilder" };
            dataGridView1.Rows.Add(row4);
        }
    }

    void button1_Click(object sender, EventArgs e)
    {
        CreateGrid();
    }
}
