using System;
using System.Windows.Forms;
using System.Drawing;
using System.Collections;
using System.Reflection;
class MyWinApp
{
  static void Main() 
  {
     // Tworzy i wywouje formularz.
     Application.Run(new SimpleForm());  
  }
}
// Formularz uytkownika potomny wzgldem klasy bazowej Form.
class SimpleForm:Form
{
 public TreeView tvEnum;
 public ListView lView;
 public TextBox AssemName;
 public Button BtnShow;
 public string netDirectory;
 public Label Description;
 public SimpleForm() 
 {
	 this.Text = "Rozdzia 7: Projekt TreeView - Lista wartoci typu wyliczeniowego";
	 this.Size= new Size(380,240);

	 tvEnum= new TreeView();
	 tvEnum.Location = new Point(10,10);
	 tvEnum.Size= new Size(180,160);
	 this.Controls.Add(tvEnum);
	 tvEnum.AfterSelect += new TreeViewEventHandler(tvEnum_AfterSelect);
	 //
	 BtnShow = new Button();
	 BtnShow.Text="Wybierz";
	 BtnShow.Location= new Point(120,180);
	 BtnShow.TabIndex=2;
	 this.Controls.Add(BtnShow);
	 BtnShow.Click += new EventHandler(ShowAssembly);
	 //
	 AssemName = new TextBox();
	 AssemName.Location= new Point(10,180);
	 AssemName.Size= new Size(100,10);
	 AssemName.TabIndex = 1;
	 this.Controls.Add(AssemName);   
	 //
	 lView = new ListView();
	 lView.Location = new Point(200,10);
	 lView.Size= new Size(150,160);
	 this.Controls.Add(lView);
	 lView.View = View.List;
	 //   
                 Description = new Label();
                 Description.Location = new Point(200,174);
                 Description.Size= new Size(180,40);
                 Description.Text= "Wpisz nazw zestawu (np. System.Drawing lub mscorlib) i kliknij przycisk Wybierz.";
                 this.Controls.Add(Description);
	 netDirectory = System.Runtime.InteropServices.RuntimeEnvironment.GetRuntimeDirectory() ;
 }  
   
 private void ShowAssembly(object sender, EventArgs e)
 {
     if( AssemName.Text.Trim().Length>2) GetEnums();
 }
 // Metoda przeszukuje wartoci Enumeration pod katem nazw zestaww .NET.
 private void GetEnums()
 {
   lView.Items.Clear();
   try
   {
     TreeNode tNode=null;
     Assembly refAssembly ;
     Hashtable ht= new Hashtable();  // Reprezentuje przestrzenie nazw.
     // Tworzy pen ciek do zestaww dla biecego rodowiska CLR.
     string assem = netDirectory+AssemName.Text;   // Uzyskuje zestaw reprezentowany w polu tekstowym.
     if(assem.ToLower().IndexOf(".dll")<0) assem= assem+".dll";
     tvEnum.Nodes.Clear();
     // Wczytuje testowany zestaw.
     refAssembly = Assembly.LoadFrom(assem);
     foreach (Type t in refAssembly.GetTypes())
     {
       // Odnajduje typy dziedziczce po typie bazowym System.Enum.
       if(t.BaseType!=null && t.BaseType.FullName=="System.Enum")
       {
          string myEnum  = t.FullName;
	      string  nSpace = myEnum.Substring(0,myEnum.LastIndexOf("."));
	      myEnum= myEnum.Substring(myEnum.LastIndexOf(".")+1) ;
	      // Okrela, czy dana przestrze nazw jest ju reprezentowana w tablicy skrtw.
	      if( ht.Contains(nSpace))
	      {  
	          // Odnajduje wze nadrzdny reprezentujcy dan przestrze nazw.
	          foreach (TreeNode tp in tvEnum.Nodes)
	          {
	              if(tp.Text == myEnum) { tNode=tp; break;}
	          }	       
	      } 
	      else
	     {                   
	     	  // Dodaje wze nadrzdny reprezentujcy odpowiedni przestrze nazw.
	     	  tNode = tvEnum.Nodes.Add(nSpace);
	     	  ht.Add(nSpace,nSpace);
	  	 }
	     // Dodaje wze potomny  nazw typu wyliczeniowego.
	     TreeNode cNode = new TreeNode();
	     cNode.Text= myEnum;
	     cNode.Tag = t;     // Zawiera nazw konkretnego typu wyliczeniowego.
	     tNode.Nodes.Add(cNode);	                     
       }                
    }  // foreach
   } catch (Exception ex)
     {MessageBox.Show(ex.Message);}
 }
  
 private void tvEnum_AfterSelect(Object sender, TreeViewEventArgs e)
 {
    TreeNode tn = e.Node;   // Zaznaczony wze.
    if(tn.Parent !=null)    // Pomija wzy nadrzdne.
    {
       lView.Items.Clear();
       Type cNode = (Type) tn.Tag;               
       foreach (MemberInfo mi in cNode.GetMembers())
       {               	   
	 	 if(mi.MemberType==MemberTypes.Field && mi.Name != "value__" )
         {	     
	         lView.Items.Add(mi.Name);
	     }               
       }           
    }       
  }   
   
} // Koniec klasy SimpleForm   